define(['modules/form/form-confirm-navigation-popup-view'], function(ConfirmNavigationPopupView) {
    'use strict';

    describe('Form Confirm Navigation Popup', function() {
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            view = new ConfirmNavigationPopupView({
                elAfterClose: '.element-for-focus',
                warningMessage: "This is a custom warning mesage for the form you're navigating away from.",
            });

            spyOn(view, 'trigger').and.callThrough();

            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h3.ui-title').text()).toEqual('Confirmation');
        });

        it('has warning message passed in as an option', function () {
            expect($view.find('.ui-content p').text())
                .toEqual("This is a custom warning mesage for the form you're navigating away from.");
        });

        it('has Continue and Return buttons', function() {
            expect($view.find('button, a[role=button]').length).toEqual(2);

            expect($view.find('.warning-continue-btn').attr('id')).toEqual('confirm-nav-continue-btn');
            expect($view.find('#confirm-nav-continue-btn').text()).toEqual('Continue');

            expect($view.find('.warning-return-btn').attr('id')).toEqual('confirm-nav-return-btn');
            expect($view.find('#confirm-nav-return-btn').text()).toEqual('Return');
        });

        it("triggers 'confirm-navigate' when the Continue button is clicked", function() {
            $view.find('.warning-continue-btn').click();
            expect(view.trigger).toHaveBeenCalledWith('confirm-navigate');
        });

        it("triggers 'cancel-navigate' when the Cancel button is clicked", function() {
            $view.find('.warning-return-btn').click();
            expect(view.trigger).toHaveBeenCalledWith('cancel-navigate');
        });
    });
});
